//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

// This is an example program for using the COM interface of SIMCA-Q dll. To build and 
// run this application you must copy SIMCAQ.tlb to the same directory where you have 
// put the source files.
//
// You must also register the SIMCA-Q.dll with regsvr32.

#pragma once

#import "SIMCAQ.tlb"
using namespace SIMCAQLib;

/////////////////////////////////////////////////////////////////////////////
// CSQPPlusCOMSampleDlg dialog

class CSQPPlusCOMSampleDlg : public CDialog
{
   DECLARE_MESSAGE_MAP()

public:
   explicit CSQPPlusCOMSampleDlg(CWnd* pParent = nullptr);	// standard constructor
   ~CSQPPlusCOMSampleDlg();

   enum { IDD = IDD_SQPPLUSCOMCLIENT_DIALOG };

   void DoDataExchange(CDataExchange* pDX) override;	// DDX/DDV support
   BOOL OnInitDialog() override;

   void GetModelParameters(IModelPtr pModel);
   void GetAlignedParameters(IBatchEvolutionModelPtr pBEModel);
   void GetResults(IModelPtr pModel, IPredictionPtr pPrediction);
   void GetAlignedResults(IModelPtr pModel, IBatchEvolutionPredictionPtr pPhasePrediction);
   void PrintVectorData(IVectorDataPtr& pfMat);
   void ProcessBatchProject();
   void ProcessContinousProject();

private:
   ISIMCAQPtr mpSQ;
   IProjectPtr mpProject;
   IBatchProjectPtr mpBatchProject;
   BOOL mbIsBatchProject = FALSE;
   FILE* mpFile = nullptr;
   HICON m_hIcon;

public:
   afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
   afx_msg void OnPaint();
   afx_msg HCURSOR OnQueryDragIcon();
   afx_msg void OnStart();
};
